from abc import ABC, abstractmethod


class PreprocessorBase(ABC):
    def __init__(self, observation_space):
        self.need_render = False # 标记该类环境是否需要render才能得到可视化图像
        self._observation_space = observation_space

    @property
    def observation_space(self):
        return self._observation_space

    @abstractmethod
    def preprocess(self, observation):
        raise NotImplementedError()

    @abstractmethod
    def render_episode(self, episode_observations):
        raise NotImplementedError()
